import paho.mqtt.client as mqtt

# The callback for when the client receives a CONNACK response from the server.
def on_connect(client, userdata, rc):
	print("Connected with result code "+str(rc))

# The callback for when a PUBLISH message is received from the server.
def on_message(client, userdata, msg):
	print(msg.topic+" "+str(msg.payload))

client = mqtt.Client(client_id="win1", clean_session=False)
client.on_connect = on_connect
client.on_message = on_message

client.username_pw_set(username="YOUR_USER_NAME", password="YOUR_PASSWORD")
client.connect(host="m11.cloudmqtt.com", port=YOURPORT, keepalive=120)

#to test qos=1
client.publish(topic="/mqtt/topic/1", payload="paho_a", qos=1, retain=False)

#to test "last known good" message, uncomment
#client.publish(topic="/mqtt/topic/1", payload="paho_last", qos=0, retain=True)

#to clear "last known good" message, uncomment
#client.publish(topic="/mqtt/topic/1", payload="", qos=0, retain=True)
