import sys #remove for linux
import paho.mqtt.client as mqtt

#this is so CTRL-C works in windows
def signal_handler(signal, frame):
	sys.exit(0)

# The callback for when the client receives a CONNACK response from the server.
def on_connect(client, userdata, rc):
	print("Connected with result code "+str(rc))
	# Subscribing in on_connect() means that if we lose the connection and
	# reconnect then subscriptions will be renewed.
	client.subscribe("/mqtt/topic/1",1)

# The callback for when a PUBLISH message is received from the server.
def on_message(client, userdata, msg):
	print(msg.topic+" "+str(msg.payload))

client = mqtt.Client(client_id="win2", clean_session=False)
client.on_connect = on_connect
client.on_message = on_message

client.username_pw_set(username="YOUR_USER_NAME", password="YOUR_PASSWORD")
client.connect(host="m11.cloudmqtt.com", port=YOURPORT, keepalive=120)

# Blocking call that processes network traffic, dispatches callbacks and
# handles reconnecting.
# Other loop*() functions are available that give a threaded interface and a
# manual interface.
try:						 	#remove for linux
	client.loop_forever()
except KeyboardInterrupt:		#remove for linux
	exit(0)						#remove for linux