/******************************************************************************
 * Author: 2015 Malcolm Yeoman
 *
 * FileName: spi_lite.h
 *
 *******************************************************************************/
#ifndef __SPILITE_H__
#define __SPILITE_H__

#include "ets_sys.h"
#include "osapi.h"
#include "gpio.h"

//Define all SPI Pins
#define SPI_OUT     PERIPHS_IO_MUX_MTMS_U     	/* Define SDA signal to be pin 14 */
#define SPI_OUT_N   14						 	/* Define SDA signal to be pin 14 */
#define SPI_CS      PERIPHS_IO_MUX_MTCK_U     	/* Define SPI CS signal to be pin 13 */
#define SPI_CS_N    13		     				/* Define SPI CS signal to be pin 13 */
#define SPI_IN      PERIPHS_IO_MUX_GPIO4_U     	/* Define SDO signal to be pin 5 (ESP-12 swaps pins) */
#define SPI_IN_N    4		     				/* Define SDO signal to be pin 5 (ESP-12 swaps pins) */
#define SPI_CLK     PERIPHS_IO_MUX_MTDI_U     	/* Define SCL signal to be pin 12 */
#define SPI_CLK_N   12					     	/* Define SCL signal to be pin 12 */

#define READ	1
#define WRITE	0

void ICACHE_FLASH_ATTR spi_init(void);
void ICACHE_FLASH_ATTR spiPutByte(uint8);
uint8 ICACHE_FLASH_ATTR spiGetByte();
void ICACHE_FLASH_ATTR spiPutAddr(uint8 , uint8 , uint8 );
void ICACHE_FLASH_ATTR spiADXL345(uint8 , uint8 , uint8 , uint8 *);


#endif
